# -*- coding: utf-8 -*-

import os

from sandbox import sdk2

from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.sport_wizard import sport_wizard_releasers


class CREATE_SPORT_DATA_EXECUTABLE(sdk2.Resource):
    """
        Binary creating data for sport proxy
    """
    auto_backup = True
    any_arch = False
    executable = True
    releasable = True
    releasers = sport_wizard_releasers
    release_subscribers = []
    arcadia_build_path = 'yweb/freshness/scripts/sport_wizard/create_sport_data'


class BuildCreateSportDataExecutable(YaMakeTask):
    type = 'BUILD_CREATE_SPORT_DATA_EXECUTABLE'
    input_parameters = ya_make_build_params() + get_arcadia_params()
    execution_space = 4 * 1024

    def get_resources(self):
        resources = {
            'description': 'Binary creating sport data',
            'resource_path': os.path.basename(CREATE_SPORT_DATA_EXECUTABLE.arcadia_build_path),
            'resource_type': CREATE_SPORT_DATA_EXECUTABLE,
        }
        return {'project': resources}

    def get_targets(self):
        return [CREATE_SPORT_DATA_EXECUTABLE.arcadia_build_path]

    def get_arts(self):
        return [{'path': CREATE_SPORT_DATA_EXECUTABLE.arcadia_build_path}]


__Task__ = BuildCreateSportDataExecutable
