#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import time
import urllib2
import datetime
import calendar

ONE_MINUTE = 60
ONE_HOUR = 60 * ONE_MINUTE
ONE_DAY = 24 * ONE_HOUR


def get_utc_timestamp(time_str):
    t = datetime.datetime.strptime(time_str, "%Y-%m-%dT%H:%M:%S.000Z")
    return int(calendar.timegm(t.utctimetuple()))


def robustFetch(url, retries=3):
    lastEx = None
    for numTry in range(retries):
        try:
            resp = urllib2.urlopen(url).read()
            return resp
        except urllib2.HTTPError as e:
            lastEx = e
            time.sleep(1.0)
    raise Exception("Failed to open url %s: %s" % (url, str(lastEx)))


def get_WC2018_events(timestamp):
    url = "https://api.sport.news.yandex.ru/v2/football/competitions/2016"
    response = robustFetch(url)
    response_json = json.loads(response)

    actualEvents = {}
    tsFrom = int(timestamp) - 4 * ONE_HOUR
    tsTo = int(timestamp) + 30 * ONE_MINUTE
    for event in response_json["events"]:
        if not event["id"].startswith("m"):
            continue
        start_timestamp = get_utc_timestamp(event["dt_start"])
        if (start_timestamp > tsFrom and start_timestamp <= tsTo):
            event["ts_start"] = start_timestamp
            if event["dt_finish"]:
                event["ts_finish"] = get_utc_timestamp(event["dt_finish"])
            actualEvents[event["id"]] = event
    return actualEvents


def get_match_info(eventId):
    url = "https://api.sport.news.yandex.ru/v2/football/events/{}".format(eventId)
    return json.loads(robustFetch(url))
