from sandbox import sdk2

import sandbox.sdk2.paths as paths
from sandbox.sdk2.helpers import subprocess as subprocess


class SportProxyBenchmarkArchiveResource(sdk2.Resource):
    releasable = True


class SportProxyBenchmarkCreateArchiveResource(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        sport_proxy_binary = sdk2.parameters.Resource('sport proxy binary', required=False)
        sport_proxy_config = sdk2.parameters.Resource('sport proxy config', required=True)
        custom_script = sdk2.parameters.Resource('custom script', required=True)

    class Context(sdk2.Context):
        child_task = None

    def copy_resource_to(self, dir_name, resource):
        paths.copy_path(str(sdk2.ResourceData(resource).path), str(dir_name))

    def copy_last_resource_to(self, dir_name, resource_name):
        resource = sdk2.Resource[resource_name].find(attrs=dict(released="stable")).first()
        print ("Loading resource with id " + str(resource.id))
        self.copy_resource_to(dir_name, resource)

    def on_execute(self):
        archive_name = "archive.tar.gz"
        dir_name = self.path('some_directory')

        paths.make_folder(dir_name)

        self.copy_last_resource_to(dir_name, "GEODB_DATA")
        self.copy_last_resource_to(dir_name, "SPORT_WIZARD_DATA")
        self.copy_resource_to(dir_name, self.Parameters.sport_proxy_config)
        self.copy_resource_to(dir_name, self.Parameters.custom_script)
        if self.Parameters.sport_proxy_binary:
            self.copy_resource_to(dir_name, self.Parameters.sport_proxy_binary)
        else:
            self.copy_last_resource_to(dir_name, "BIATHLON_PROXY_EXECUTABLE")

        archive_resource = sdk2.ResourceData(SportProxyBenchmarkArchiveResource(
            self, "Archive with APP_HOST_BENCHMARK-ready sport proxy app", archive_name
        ))
        command = ["tar", "cvzf", str(archive_resource.path), 'some_directory']
        with sdk2.helpers.ProcessLog(self, logger="tar") as pl:
            subprocess.Popen(command, stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

        archive_resource.ready()
