class PushesDatabase(object):
    def get_next_id(self, counterName):
        value = self.db.counters.find_and_modify(
            {'_id': counterName},
            {'$inc': {'index': 1}},
            upsert=True,
            new=True
        )
        return value['index']

    def get_iteration(self):
        for value in self.db.counters.find({'_id': "iteration"}):
            return value["index"]
        return 0

    def inc_iteration(self):
        return self.get_next_id("iteration")

    def __init__(self, current_timestamp, config):
        from pymongo import MongoClient

        self.current_timestamp = current_timestamp
        kwOptions = {}
        if 'mongoWriteReplicas' in config:
            kwOptions['w'] = config['mongoWriteReplicas']
        if 'mongoWaitJournaling' in config:
            kwOptions['j'] = config['mongoWaitJournaling']
        if 'mongoReplicaSet' in config:
            self.mongoClient = MongoClient(
                config['mongoReplicaSet'],
                **kwOptions
            )
        else:
            self.mongoClient = MongoClient(
                host=config['mongoHost'],
                port=config['mongoPort'],
                **kwOptions
            )
        self.db = self.mongoClient[config['databaseName']]
        self.iteration = self.get_iteration()

    def load_previous_actual_events(self):
        events = {}
        findCondition = {'iteration': {'$eq': self.iteration}}
        for event_state in self.db.event_states.find(findCondition):
            events[event_state["event_id"]] = event_state["event"]
        return events

    def log_message(self, encoded_msg):
        self.db.message_log.insert({
            "timestamp": self.current_timestamp,
            "msg": encoded_msg
        })

    def save_push(self, push):
        push["push_id"] = self.get_next_id("push_id")
        push["_id"] = push["push_id"]  # internal mongo id
        push["timestamp"] = self.current_timestamp
        self.db.pushes.insert(push)

    def save_current_actual_events(self, events):
        for eventId, event in events.iteritems():
            eventRecord = {"event": event}
            eventRecord["event_id"] = eventId
            eventRecord["iteration"] = self.iteration + 1
            eventRecord["_id"] = self.get_next_id("event_states_id")
            eventRecord["timestamp"] = self.current_timestamp
            self.db.event_states.insert(eventRecord)

    def update_current_actual_events(self, events):
        for eventId, event in events.iteritems():
            self.db.event_states.update(
                {'event_id': eventId, "iteration": self.iteration},
                {'$set': {'iteration': self.iteration + 1, 'timestamp': self.current_timestamp}},
                upsert=True
            )
