# coding=utf-8
from sandbox import sdk2


class SpravResourceBase(sdk2.Resource):
    __abstract__ = True
    releasable = True
    releasers = [
        'ALTAY',
        'robot-testenv'
    ]


class SpravLibsForScala(SpravResourceBase):
    pass


class SpravFeedbackServerBinary(SpravResourceBase):
    pass


class SpravFeedbackServerConfigs(SpravResourceBase):
    pass


class SpravFeedbackProcessorBinary(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/feedback_processor/bin/ya.make
    """
    pass


class SpravFeedbackProcessorConfigs(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/feedback_processor/configs/ya.make
    """
    pass


class SpravFeedbackDataProxyBinaries(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/ext_instruments/bin/ya.make
    """
    pass


class SpravFeedbackDataProxyConfigs(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/ext_instruments/configs/ya.make
    """
    pass


class SpravFeedbackGeospamProcessorBinaries(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/geospam_processor/bin/ya.make
    """
    pass


class SpravFeedbackGeospamProcessorConfigs(SpravResourceBase):
    """
    See https://a.yandex-team.ru/arc_vcs/sprav/feedback/packages/geospam_processor/configs/ya.make
    """
    pass
