# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class SPRAV_EDITOR_BINARY(sdk2.Resource):
    """
        Бинарник sprav-editor
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/java/editor'
    artifacts = [
        'sprav/java/editor/sprav-editor',
        'sprav/java/editor/sprav-editor.jar',
        'sprav/java/editor/run.sh'
    ]


class ALTAY_EXPORT_PROXY_PACK(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/export/http_proxy'
    artifacts = [
        'sprav/altay/export/http_proxy/download_file.sh',
        'sprav/altay/export/http_proxy/nginx.conf',
        'sprav/altay/export/http_proxy/run.sh'
    ]


class ALTAY_FEEDS_BINARY(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/import/service'
    artifacts = [
        'sprav/altay/import/service/service'
    ]


class TYCOON_PHOTO_API(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/java/photo-api'
    artifacts = [
        'sprav/java/photo-api/java-photo-api',
        'sprav/java/photo-api/java-photo-api.jar'
    ]


class SPRAV_PHOTO_API(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/java/sprav-photo-api/'
    artifacts = [
        'sprav/java/sprav-photo-api/java-sprav-photo-api',
        'sprav/java/sprav-photo-api/java-sprav-photo-api.jar'
    ]


class SPRAV_SIMILAR_PERMALINKS_SEARCH(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/similar_permalinks_search'
    artifacts = [
        'sprav/altay/similar_permalinks_search/similarity-server',
    ]


class SPRAV_UNIFICATION_SERVER(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/algorithms/unification/server'
    artifacts = [
        'sprav/algorithms/unification/server/unification-server',
    ]


class SPRAV_YABS_GRAPHITE_SENDER(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class SPRAV_SAAS_PUSH_CONFIGS(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/saas'
    artifacts = [
        'sprav/altay/saas/docker-entrypoint.sh',
        'sprav/altay/saas/prestable.config',
        'sprav/altay/saas/saas-logrotate.conf',
        'sprav/altay/saas/stable.config'
    ]


class SPRAV_CALCULATE_SIMILARITY_SERVER(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/tools/calculate_similarity_server'
    artifacts = [
        'sprav/altay/tools/calculate_similarity_server/calculate-similarity-server',
    ]


class SPRAV_CALCULATE_SIMILARITY_SERVER_CONFIG(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/sprav_db/configs'
    artifacts = [
        'sprav/altay/sprav_db/configs/prod_yt.txt'
    ]


class SPRAV_STREAM_SIGNALS_PUSH_LOADER(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'sprav/altay/import/stream/push_loader'
    artifacts = [
        'sprav/altay/import/stream/push_loader/push_loader'
    ]


class SPRAV_YT_STAT(sdk2.Resource):
    auto_backup = True
