import logging
from os.path import abspath
import re
from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia


class UpdateGeodataResource(sdk2.Task):
    """Task that updates GEOBASE_RESOURCE_ID in ya.make with newest version"""

    class Parameters(sdk2.Task.Parameters):
        project_path = sdk2.parameters.String('Target directory with ya.make file', default='web/src_setup/lib/setup/region/')

    def update_resource(self, path_to_file, newest_resource):
        file_data = ''
        with open(path_to_file, 'r') as original:
            for line in original:
                if 'SET(GEOBASE_RESOURCE_ID ' in line:
                    current_resource = int(re.search(r'SET\(GEOBASE_RESOURCE_ID (.*)\)', line).group(1))
                    line = line.replace(str(current_resource), str(newest_resource))
                file_data += line
        with open(path_to_file, 'w') as file:
            file.write(file_data)

    def get_newest_resource_id(self):
        return sdk2.Resource['GEODATA_TREE_LING_STABLE'].find(attrs=dict(released='stable')).first().id

    def on_execute(self):
        ARCADIA_URL = 'arcadia:/arc/trunk/arcadia/'
        local_path = abspath('ya_make')
        Arcadia.checkout(ARCADIA_URL + self.Parameters.project_path, local_path)

        newest_resource = self.get_newest_resource_id()
        logging.info(newest_resource)

        self.update_resource(local_path + '/ya.make', newest_resource)

        comment = 'SKIP_CHECK {} update geodata with new id:{}\nhttps://sandbox.yandex-team.ru/task/{}/view'.format(self.type, newest_resource, self.id)
        Arcadia.commit(local_path, comment, user='zomb-sandbox-rw')
