import logging
from os.path import abspath
import re
from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia


class UpdateVideoPopularConfig(sdk2.Task):
    """Task that updates video_popular_config.json in ya.make with newest version"""

    class Parameters(sdk2.Task.Parameters):
        project_path = sdk2.parameters.String('Target directory with ya.make file', default='web/src_setup/lib/setup/video_popular/data')

    def update_resource(self, path_to_file, newest_resource):
        file_data = ''
        with open(path_to_file, 'r') as original:
            for line in original:
                if 'SET(VIDEO_POPULAR_CONFIG_RESOURCE_ID ' in line:
                    current_resource = int(re.search(r'SET\(VIDEO_POPULAR_CONFIG_RESOURCE_ID (.*)\)', line).group(1))
                    line = line.replace(str(current_resource), str(newest_resource))
                file_data += line
        with open(path_to_file, 'w') as file:
            file.write(file_data)

    def get_newest_resource_id(self):
        return sdk2.Resource['VIDEO_POPULAR_CONFIG'].find(attrs=dict(released='stable')).first().id

    def on_execute(self):
        ARCADIA_URL = 'arcadia:/arc/trunk/arcadia/'
        local_path = abspath('ya_make')
        Arcadia.checkout(ARCADIA_URL + self.Parameters.project_path, local_path)

        newest_resource = self.get_newest_resource_id()
        logging.info(newest_resource)

        self.update_resource(local_path + '/ya.make', newest_resource)

        comment = '{} update video_popular_config.json with new id:{}\nhttps://sandbox.yandex-team.ru/task/{}/view'.format(self.type, newest_resource, self.id)
        Arcadia.commit(local_path, comment, user='zomb-sandbox-rw')
