# -*- coding: utf-8 -*-
from __future__ import absolute_import, print_function

import os

from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process


class RtcSreBotRun(sdk2.Task):
    """
    yet another devops pinger for forsaken tickets
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 4096
        ram = 4096

    class Parameters(sdk2.Task.Parameters):
        # set task parameters

        with sdk2.parameters.RadioGroup('configuration') as configuration:
            configuration.values['runtimecloud'] = configuration.Value(value='runtimecloud')
            configuration.values['hardwareio'] = configuration.Value(value='hardwareio')
            configuration.values['all'] = configuration.Value(value='all', default=True)

        dry_run = sdk2.parameters.Bool(
            "Do not post comments in startrek (for debugging purposes)",
            default=False,
        )

        tg_notify = sdk2.parameters.Bool(
            "Telegram notifications",
            default=False,
        )
        with tg_notify.value[True]:
            tg_token_vault = sdk2.parameters.String(
                "telegram token vault_name",
                default=False,
            )
            tg_chat_id = sdk2.parameters.String(
                "telegram chat id",
                default=False,
            )

        st_period = sdk2.parameters.String(
            "Startrek retrospective period",
            default=False,
        )
        user_agent = sdk2.parameters.String(
            "Useragent",
            default=False,
        )
        oauth_token_vault = sdk2.parameters.String(
            "Oauth token sandbox vault_name",
            default=False,
        )

    def on_execute(self):
        # tg notification settings
        self.tg_notify = self.Parameters.tg_notify
        if self.tg_notify:
            self.tg_token = sdk2.Vault.data(self.Parameters.tg_token_vault)
            self.tg_chat_id = sdk2.Vault.data(self.Parameters.tg_chat_id)

        # startrek dry run option
        self.dry_run = self.Parameters.dry_run

        # startrek common options
        self.user_agent = self.Parameters.user_agent
        self.oauth_token = sdk2.Vault.data(self.Parameters.oauth_token_vault)
        self.st_period = self.Parameters.st_period

        # st queue
        self.st_queue = self.Parameters.configuration

        # checkout latest sre bot binary
        rtc_sre_bot_bin_resource = sdk2.Resource["SRE_RTC_BOT_BINARY"].find().order(-sdk2.Task.id).first()
        rtc_sre_bot_binary = sdk2.ResourceData(rtc_sre_bot_bin_resource)
        rtc_sre_bot_binary_path = str(rtc_sre_bot_binary.path)

        # checkout latest config
        rtc_sre_bot_config_resource = sdk2.Resource["SRE_RTC_BOT_CONF"].find().order(-sdk2.Task.id).first()
        rtc_sre_bot_config = sdk2.ResourceData(rtc_sre_bot_config_resource)
        rtc_sre_bot_config_path = str(rtc_sre_bot_config.path)

        # main cmdline
        cmd_line = [rtc_sre_bot_binary_path,
                    '-c', rtc_sre_bot_config_path,
                    '-t', self.st_period,
                    '-p', self.st_queue,
                    ]
        env_line = dict(os.environ, OAUTH=self.oauth_token, UA=self.user_agent)

        # create additional args lines
        if self.tg_notify:
            tg_env = {'TG_TOKEN': self.tg_token, 'TG_CHATID': self.tg_chat_id}
            tg_cmd = ['-tg']
            cmd_line.extend(tg_cmd)
            env_line = dict(env_line, **tg_env)
        if self.dry_run:
            cmd_line.extend(['-dry'])

        run_process(cmd_line, environment=env_line)
