# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, division

from sandbox import sdk2

from sandbox.projects.sandbox import LXC_CONTAINER
from sandbox.projects.resource_types import YA_PACKAGE as _YA_PACKAGE


CORE_TEAM = ('sinister', 'kender', 'aivanf')
ROBOTS = ()


# noinspection PyPep8Naming
class STATBOX_ABT_BASE_LXC_IMAGE(LXC_CONTAINER):
    """
    Базовый LXC контейнер для сборки библиотеки и запуска расчетов.

    """

    releasers = CORE_TEAM + ROBOTS


# noinspection PyPep8Naming
class STATBOX_ABT_METRICS_BUNDLE(sdk2.Resource):
    """
    Relocatable virtualenv с statbox-abt-metrics и зависимостями.

    NB: виртуальная среда содержит симлинки на базовую инсталляцию python,
    в данном случае /pyenv/versions/2.7.13, и не будет работать без
    этой директории. Так сделано по двум причинам. Во-первых, размер образа
    получается меньше. Во-вторых, virtualenv линкует не всю стандартную
    библиотеку, но лишь ее основную часть, так что создать полностью независимую
    инсталляцию питона крайне сложно.

    """

    releasable = True
    releasers = CORE_TEAM + ROBOTS

    package_version = sdk2.parameters.String('Package version')
    python_version = sdk2.parameters.String('Python version')


class STATBOX_ABT_METRICS_BIN(_YA_PACKAGE):
    """
    Ресурс для использования в таске YA_PACKAGE, который содерджит бинарную сборку
    statbox-abt-metrics.
    """

    releasers = CORE_TEAM + ROBOTS


# noinspection PyPep8Naming
class STATBOX_ABT_BACKEND_BUNDLE(sdk2.Resource):
    """
    Relocatable virtualenv с statbox-abt-backend и зависимостями.

    NB: виртуальная среда содержит симлинки на базовую инсталляцию python,
    в данном случае /pyenv/versions/3.6.2, и не будет работать без
    этой директории. Так сделано по двум причинам. Во-первых, размер образа
    получается меньше. Во-вторых, virtualenv линкует не всю стандартную
    библиотеку, но лишь ее основную часть, так что создать полностью независимую
    инсталляцию питона крайне сложно.

    """

    releasable = True
    releasers = CORE_TEAM + ROBOTS

    package_version = sdk2.parameters.String('Package version')
    python_version = sdk2.parameters.String('Python version')


# noinspection PyPep8Naming
class STATBOX_ABT_METRICS_RESULT(sdk2.Resource):
    """Json файл с результатом вычисления метрик"""

    r_service = sdk2.parameters.String('Service')
    r_metric_groups = sdk2.parameters.String('Metric groups')
    r_experiments = sdk2.parameters.String('Experiments')
    r_start_date = sdk2.parameters.String('Start date')
    r_end_date = sdk2.parameters.String('End date')
    r_scale = sdk2.parameters.String('Scale')
    abt_id = sdk2.parameters.String('Abt id')


class STATBOX_ABT_METRICS_REGRESSION_INPUT(sdk2.Resource):
    """
    Входные данные для локального регресионного теста пакета statbox-abt-metrics.
    Один ресурс соответствует одному входу в одном тесте.

    """

    revision = sdk2.parameters.String('Revision', required=True)
    md5_hash = sdk2.parameters.String('MD5 hash', required=True)
    filename = sdk2.parameters.String('Filename', required=True)
