# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, division

import textwrap

from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease

from .. import STATBOX_ABT_BASE_LXC_IMAGE
from ..utils.pyenv import PYENV_REPO, PYENV_ROOT, PYTHON_VERSIONS


class StatboxAbtLxc(SandboxLxcImage):
    def on_create(self):
        self.Parameters.ubuntu_release = UbuntuRelease.TRUSTY
        self.Parameters.custom_image = True
        self.Parameters.test_result_lxc = False
        self.Parameters.custom_script = self.make_install_script()
        self.Parameters.custom_packages = self.make_install_requirements()
        self.Parameters.resource_type = STATBOX_ABT_BASE_LXC_IMAGE.__name__

    @staticmethod
    def make_install_script():
        script = textwrap.dedent(r'''
            export PYENV_ROOT="{PYENV_ROOT}"

            git clone {PYENV_REPO} ${{PYENV_ROOT}}
            cd ${{PYENV_ROOT}}

            export PATH="${{PYENV_ROOT}}/bin:$PATH"

            eval "$(pyenv init -)"
        '''.format(PYENV_REPO=PYENV_REPO, PYENV_ROOT=PYENV_ROOT))

        for version in PYTHON_VERSIONS:
            script += textwrap.dedent(r'''
                pyenv install {V}
                /pyenv/versions/{V}/bin/pip install -U pip setuptools wheel
                /pyenv/versions/{V}/bin/pip install -U virtualenv cython
            '''.format(V=version))

        return script

    @staticmethod
    def make_install_requirements():
        install_requirements = textwrap.dedent('''
            python-dev libssl-dev libyaml-dev make build-essential
            libssl-dev zlib1g-dev libbz2-dev libreadline-dev libsqlite3-dev
            wget curl git llvm libncurses5-dev libncursesw5-dev xz-utils tk-dev
            apt-transport-https ca-certificates software-properties-common
        ''')

        return install_requirements.replace('\n', ' ')
