import os
import tarfile

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import parameters

from sandbox.projects.statinfra import STATINFRA_EVENT_PROCESSOR


class CreateStatinfraEventProcessorResource(SandboxTask):
    type = 'CREATE_STATINFRA_EVENT_PROCESSOR_RESOURCE'

    environment = (environments.PipEnvironment('GitPython'),)

    class RepoUrl(parameters.SandboxStringParameter):
        name = 'repo_url'
        description = 'Repo URL'
        multiline = False
        default_value = 'https://github.yandex-team.ru/dmifedorov/second_step.git'

    class Revision(parameters.SandboxStringParameter):
        name = 'revision'
        description = 'SHA of revision'
        multiline = False
        default_value = ''

    input_parameters = [RepoUrl, Revision]

    def on_execute(self):
        import git
        tar = tarfile.open('events.tar.gz', 'w:gz')
        git.Git().clone(self.ctx[self.RepoUrl.name], 'events')
        os.chdir('events')

        revision = self.ctx.get(self.Revision.name)
        repo = git.Repo('.')
        if revision:
            repo.git.reset('--hard', revision)
        else:
            revision = repo.rev_parse('HEAD').hexsha

        for filename in os.listdir('.'):
            tar.add(filename)

        tar.close()
        self.create_resource(
            description='Statinfra EventProcessor %s' % revision,
            resource_path='events.tar.gz',
            resource_type=STATINFRA_EVENT_PROCESSOR
        )


__Task__ = CreateStatinfraEventProcessorResource
