# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.statinfra import STATINFRA_THEMES_CLASSIFIER


DEFAULT_YT_PATH = '//tmp/STATINFRA-9898/thematics'
DEFAULT_YT_CLUSTER = 'hahn'
FILENAME = 'thematics.json'


class CreateStatinfraThemesClassifier(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        environments = (
            PipEnvironment('yandex-yt'),
            PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )

    class Parameters(sdk2.Task.Parameters):
        themes_yt_path = sdk2.parameters.String(
            'Themes classifier YT path',
            default_value=DEFAULT_YT_PATH,
        )
        yt_cluster = sdk2.parameters.String(
            'YT cluster',
            default_value=DEFAULT_YT_CLUSTER,
        )

    def on_execute(self):
        import json
        import yt.wrapper as yt

        yt.config['token'] = sdk2.Vault.data('ANALYTICSKEYMETRICS', 'KEYMETRICS_JAM_TOKEN')
        yt.config['proxy']['url'] = '{}.yt.yandex.net'.format(self.Parameters.yt_cluster)
        themes_table = yt.read_table(self.Parameters.themes_yt_path)

        themes = dict()
        for record in themes_table:
            themes[record['host']] = record['major_suggestion']

        with open(FILENAME, 'w') as fp:
            json.dump(themes, fp)

        resource = sdk2.ResourceData(
            STATINFRA_THEMES_CLASSIFIER(self, FILENAME, FILENAME)
        )
        resource.ready()
