# -*- coding: utf-8 -*-

import os
import sandbox.common.types.resource as ctr
from os.path import join
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sdk2.helpers import subprocess as sp

from sandbox import sdk2
from . import config
from .. import STATINFRA_LXC_CONTAINER
from ..extra import VENVS_ROOT, juggler_push

ROOT_PREFIX = '_ROOT_'
REVISION_ATTR_PREFIX = 'revision__'
VENVS_RESOURCE_FILE = 'venvs.squashfs'


class CreateStatinfraVenvs(sdk2.Task):
    """Сборка виртуальных окружений Statinfra"""
    # BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WA
    #
    # This task runs diffirent ways in testing/production.
    # https://st.yandex-team.ru/STATINFRA-10499
    #
    # BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WARNING BIG WA
    name = config.TASK_NAME

    class Requirements(sdk2.Task.Requirements):
        privileged = True
        environments = PipEnvironment('virtualenv==16.7.9'),

    class Parameters(sdk2.Task.Parameters):
        container = sdk2.parameters.Container('LXC Container', resource_type=STATINFRA_LXC_CONTAINER, required=True)
        update_venvs = sdk2.parameters.Bool('Force update {}'.format(VENVS_RESOURCE_FILE), default=False)
        venv_repos = sdk2.parameters.Dict('Virtualenvs repositories (repo: prefix)', default={
            'arcadia:/arc/trunk/arcadia/statbox/jam/virtualenv': ROOT_PREFIX
        })

    def on_create(self):
        self.Parameters.container = STATINFRA_LXC_CONTAINER.find(status=ctr.State.READY).first().id

    def on_execute(self):
        prev_revisions, revisions = {}, {}
        update_venvs = False
        penv = os.environ.copy()
        penv['PYTHONPATH'] = ''
        prev_resource = config.VENVS_RESOURCE.find(state=ctr.State.READY).first()
        if prev_resource:
            prev_revisions = {i: prev_resource.__attrs__[i] for i in prev_resource.__attrs__.keys() if i.startswith(REVISION_ATTR_PREFIX)}
        for repo, prefix in self.Parameters.venv_repos.items():
            _repo = '/'.join(repo.split('/')[-3:])
            revisions['{}{}'.format(REVISION_ATTR_PREFIX, _repo)] = svn.Arcadia.info(repo)['commit_revision']
        if revisions != prev_revisions or self.Parameters.update_venvs:
            update_venvs = True
        if update_venvs:
            self.set_info('Updating {}'.format(VENVS_RESOURCE_FILE))
            if os.path.islink(VENVS_ROOT):
                os.remove(VENVS_ROOT)
            for repo, prefix in self.Parameters.venv_repos.items():
                svn.Arcadia.checkout(repo, prefix)
                with sdk2.helpers.ProcessLog(self, logger='virtualenv.{}'.format(prefix)) as pl:
                    for root, dirs, files in os.walk(prefix, followlinks=True):
                        for filename in files:
                            if filename.endswith('.txt'):
                                req_file = join(root, filename)
                                venv_name = req_file.replace('{}/'.format(ROOT_PREFIX), '', 1) if prefix == ROOT_PREFIX else req_file
                                venv_path = join(VENVS_ROOT, venv_name)[:-4]
                                python, pip = join(venv_path, 'bin/python'), join(venv_path, 'bin/pip')
                                if os.path.exists(venv_path):
                                    raise Exception('Path for virtualenv already exists ({})'.format(venv_path))
                                sp.check_call(
                                    ['virtualenv', '--python', '/usr/bin/python', '--system-site-packages', '--always-copy', venv_path],
                                    env=penv, stdout=pl.stdout, stderr=pl.stderr
                                )
                                # is it really need?
                                # sp.check_call(['virtualenv', '--relocatable', venv_path], stdout=pl.stdout, stderr=pl.stderr)
                                sp.check_call([python, pip, 'install', '--upgrade', 'pip'], env=penv, stdout=pl.stdout, stderr=pl.stderr)
                                sp.check_call([python, pip, 'install', '--upgrade', 'setuptools'], env=penv, stdout=pl.stdout, stderr=pl.stderr)
                                sp.check_call([python, pip, 'install', '--upgrade', 'wheel'], env=penv, stdout=pl.stdout, stderr=pl.stderr)
                                sp.check_call(
                                    [
                                        python, pip, 'install',
                                        '--index-url', 'https://pypi.yandex-team.ru/simple',
                                        '--requirement', req_file,
                                    ],
                                    env=penv, stdout=pl.stdout, stderr=pl.stderr
                                    )
            mksquashfs = ['mksquashfs']
            mksquashfs.extend(['{}/{}'.format(VENVS_ROOT, i) for i in os.listdir(VENVS_ROOT)])
            mksquashfs.extend([VENVS_RESOURCE_FILE])
            with sdk2.helpers.ProcessLog(self, logger='mksquashfs') as pl:
                sp.check_call(mksquashfs, stdout=pl.stdout, stderr=pl.stderr)
            sdk2.ResourceData(config.VENVS_RESOURCE(self, VENVS_RESOURCE_FILE, VENVS_RESOURCE_FILE, **revisions)).ready()
        else:
            self.set_info("{} doesn't need to update".format(VENVS_RESOURCE_FILE))

    def on_success(self, prev_status):
        juggler_push(
            host=config.JUGGLER_HOST,
            service=config.TASK_NAME,
            status='OK',
            description='create_statinfra_vens success',
        )
        super(CreateStatinfraVenvs, self).on_success(prev_status)

    def on_failure(self, prev_status):
        juggler_push(
            host=config.JUGGLER_HOST,
            service=config.TASK_NAME,
            status='CRIT',
            description='create_statinfra_venvs failure',
        )
        super(CreateStatinfraVenvs, self).on_failure(prev_status)
