import os

from sandbox import sandboxsdk
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import parameters as par
from sandbox.sandboxsdk.process import run_process

import sandbox.common.types.resource as ctr
import sandbox.common.types.misc as ctm

from sandbox.projects.common.apihelpers import get_last_resource_with_attribute
from sandbox.projects.sandbox import LXC_CONTAINER


class RunSok(SandboxTask):
    type = 'RUN_SOK'

    execution_space = 20000
    environment = (
        sandboxsdk.environments.PipEnvironment('GitPython'),
    )
    dns = ctm.DnsType.DNS64

    class TaskContainer(par.Container):
        description = 'container'

        @property
        def default_value(self):
            container = get_last_resource_with_attribute(
                LXC_CONTAINER,
                attribute_name='target',
                attribute_value='sok',
                status=ctr.State.READY,
            )
            return container.id

    class RepoUrl(par.SandboxStringParameter):
        name = 'repo_url'
        description = 'repo url'
        default_value = 'https://github.yandex-team.ru/statbox/sok.git'

    input_parameters = [TaskContainer, RepoUrl]

    def initCtx(self):
        self.ctx['kill_timeout'] = 3 * 24 * 60 * 60

    def on_execute(self):
        import git
        repo_address = self.ctx[RunSok.RepoUrl.name]

        git.Git().clone(repo_address, depth=1)
        path = repo_address.split('/')[-1].split('.')[0]
        self.set_info(os.listdir(path))
        os.chdir(path)

        maven_settings_url = 'https://github.yandex-team.ru/raw/artifactory/settings.xml/master/settings.xml'
        run_process(
            'wget %s' % maven_settings_url,
            shell=True, check=True, log_prefix='get_maven_settings'
        )

        run_process(
            'mvn --settings settings.xml clean test -Dwiki.log.level=BASIC',
            shell=True, check=True, log_prefix='exec'
        )


__Task__ = RunSok
