# coding: utf8
import os
import datetime
import time
import re

from sandbox import sandboxsdk

from sandbox import common


def hide_oauth(line):
    return re.sub(r'AQAD-[\w-]+', 'AQAD-***', line)


def write_task_execution_log(self, exit_code=-1, stdouterr='', failed=False):
    if not failed:
        stdouterr = ''

    import pytz
    local_tz = pytz.timezone('Europe/Moscow')

    rest = self.server

    def utc_to_local_str(utc_dt):
        local_dt = utc_dt.replace(tzinfo=pytz.utc).astimezone(local_tz)
        return local_tz.normalize(local_dt).strftime('%Y-%m-%d %H:%M:%S')

    audit = rest.task[self.id].audit.read()
    executing_audit = [a for a in audit if a.get('status', '') == 'EXECUTING']
    if executing_audit:
        executing_audit = executing_audit[-1]
    enqueuing_audit = [a for a in audit if a.get('status', '') == 'ENQUEUED']
    if enqueuing_audit:
        enqueuing_audit = enqueuing_audit[-1]

    executing_start_time = None
    enqueuing_start_time = None
    time_taken = None
    user_time_taken = None

    if executing_audit:
        try:
            executing_start_time = datetime.datetime.strptime(
                executing_audit['time'],
                '%Y-%m-%dT%H:%M:%S.%fZ'
            )
        except ValueError:
            executing_start_time = datetime.datetime.strptime(
                executing_audit['time'],
                '%Y-%m-%dT%H:%M:%SZ'
            )

        time_taken = (datetime.datetime.utcnow() - executing_start_time).total_seconds()

    if enqueuing_audit:
        try:
            enqueuing_start_time = datetime.datetime.strptime(
                enqueuing_audit['time'],
                '%Y-%m-%dT%H:%M:%S.%fZ'
            )
        except ValueError:
            enqueuing_start_time = datetime.datetime.strptime(
                enqueuing_audit['time'],
                '%Y-%m-%dT%H:%M:%SZ'
            )

        user_time_taken = (datetime.datetime.utcnow() - enqueuing_start_time).total_seconds()

    event_params = self.Parameters.event_params or {}
    semaphores = []
    if self.Requirements.semaphores:
        sem_dict = self.Requirements.semaphores.to_dict()
        semaphores = [x['name'] for x in sem_dict['acquires']]

    row = {
        'tskv_format': 'task-execution-log',
        'unixtime': int(time.time()),
        'task_id': getattr(self.Parameters.primary_sandbox_task_id, 'id', self.Parameters.primary_sandbox_task_id),
        'task_action_id': self.Parameters.action_id,
        'task_params': '\\t' + '\\t'.join('%s=%s' % (k, v) for k, v in event_params.items())
                       + '\\t' * len(event_params.items()),
        'task_start_time': utc_to_local_str(enqueuing_start_time) if enqueuing_start_time else '',
        'task_priority': self.Parameters.prio,
        'task_options': 'DEPRECATED',
        'task_semaphores': '\\t' + '\\t'.join(semaphores) + '\\t' * len(semaphores),
        'executor_host': common.config.Registry().this.id,
        'executor_pid': '',  # ??!?
        'executor_start_time': utc_to_local_str(executing_start_time) if executing_start_time else '',
        'failure': hide_oauth(stdouterr.replace('\n', '\\n').replace('\t', '\\t')),
        'time_taken_sec': time_taken if time_taken else '',
        'user_time_taken_sec': user_time_taken if user_time_taken else '',
        'run_id': self.id,
        'sys_time_taken_sec': '',  # ??!?
        'mem_leaked_bytes': '',  # ??!?
        'io_read_bytes': '',  # ??!?
        'io_written_bytes': '',  # ??!?
        'exit_code': exit_code,
    }

    task_execution_log_path = os.path.join(sandboxsdk.paths.get_logs_folder(), 'task-execution-log.log')
    with open(task_execution_log_path, 'w') as f:
        f.write(
            'tskv\t' + '\t'.join(['%s=%s' % (str(k), str(v)) for k, v in row.items()]) + '\n'
        )
