import logging
import errno
import os

from sandbox.sandboxsdk import paths
from sandbox.sandboxsdk import process

from .config import PRIO_ADDITION


def start_tcpdump(ports):
    port_params = []
    for p in ports:
        port_params += ['or', str(p)]
    port_params = port_params[1:]

    tcp_dump_proc = process.run_process(
        [
            'tcpdump', '-i', 'any', 'tcp',
            'port',
        ] + port_params + [
            '-s', '20000',
            '-w', paths.get_logs_folder() + '/tcpdump.pcap',
        ],
        wait=False,
        log_prefix='sudo_tcpdump'
    )
    logging.info('tcpdump pid %s, return code %s', tcp_dump_proc.pid, tcp_dump_proc.returncode)
    return tcp_dump_proc


def stop_tcpdump(tcp_dump_proc):
    if tcp_dump_proc is None:
        return

    tcp_dump_proc.terminate()
    logging.info('tcpdump process terminated')


def pw_to_stat_prio(pw):
    return PRIO_ADDITION - float(pw)


def stat_prio_to_pw(stat_prio):
    return -float(stat_prio) + PRIO_ADDITION


def mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:  # Python >2.5
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else:
            raise


def silently(f):
    def wrap(*args, **kwargs):
        try:
            return f(*args, **kwargs)
        except Exception:
            logging.exception('Failed to {}'.format(f.__name__))

    return wrap
