# coding: utf-8
from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.statkey.resources_types import RELEASERS, StatkeyUndoCheventCookedLogBinary


class BuildStatkeyUndoCheventCookedLog(YaMakeTemplate.YaMakeTemplate):
    """
        Build Statkey binary for applying undo records to bs-chevent-cooked-log
    """
    class Parameters(YaMakeTemplate.get_project_params([StatkeyUndoCheventCookedLogBinary])):
        pass

    @property
    def release_template(self):
        return sdk2.ReleaseTemplate(
            sorted(RELEASERS),
            'Release Statkey binary for applying undo records to bs-chevent-cooked-log',
            self.Context.changelog.strip(),
            [ctt.ReleaseStatus.TESTING, ctt.ReleaseStatus.STABLE]
        )
