# coding: utf-8
from sandbox import sdk2


RELEASERS = [
    'chertkova',
    'edmalyh',
    'kkastsevich',
    'komandr',
    'makseshina',
    'redflower',
    'amatanhead',
    'robot-statkey',
    'bagiro44'
]


class BSClickHouseDumperToYT(sdk2.Resource):
    """
        Bin task BSClickHouseDumperToYT
    """
    releasable = True
    auto_backup = True
    releasers = RELEASERS


class MoneyMapFrontend(sdk2.Resource):
    """
        MoneyMap frontend docker
    """
    releasable = True
    auto_backup = True
    releasers = RELEASERS


class MoneyMapBackend(sdk2.Resource):
    """
        MoneyMap backend jar
    """
    releasable = True
    auto_backup = True
    releasers = RELEASERS


class StatkeyDspCookedLogBinary(sdk2.Resource):
    """
        Statkey binary for creating bs-dsp-cooked-log
    """
    # any_arch = False
    # releasable = True
    # releasers = ['robot-statkey']
    # auto_backup = True
    arcadia_build_path = 'statbox/statkey/jam/jobs/cooked_logs/bs-dsp-cooked-log/v1/src'


class StatkeyUndoCheventCookedLogBinary(sdk2.Resource):
    """
        Statkey binary for applying undo records to bs-chevent-cooked-log
    """

    releasable = True
    releasers = RELEASERS
    arcadia_build_path = 'statbox/statkey/jam/actions/cooked_logs/bs-chevent-cooked-log/v2/slave/src'


class StatkeyUndoDspCookedLogBinary(sdk2.Resource):
    """
        Statkey binary for applying undo records to bs-dsp-cooked-log
    """

    releasable = True
    releasers = RELEASERS
    arcadia_build_path = 'statbox/statkey/jam/actions/cooked_logs/bs-dsp-cooked-log/v1/slave/src'


class DataCatalogBackendBin(sdk2.Resource):
    """
        Resource for backend of data catalog in deploy
    """
    releasable = True
    releasers = RELEASERS
    ttl = 'inf'
    executable = True
