# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import glob
import logging
import os


def find_file_by_glob(prefix=None, suffix=None):
    glob_pattern = '{}*{}'.format(prefix or '', suffix or '')

    logging.info('Looking up file for pattern %r...', glob_pattern)
    logging.debug(' - working directory: %r', os.getcwd())

    found_files = glob.glob(glob_pattern)

    if len(found_files) == 0:
        raise RuntimeError('No files found for glob {!r}'.format(glob_pattern))

    if len(found_files) > 1:
        raise RuntimeError(
            'Several candidates found for glob {!r}: {}'
            .format(glob_pattern, found_files)
        )

    result = os.path.abspath(found_files[0])
    logging.info('Found file: %r', result)

    return result


def make_html_link(url, title=None):
    return '<a href="{}" target="_blank">{}</a>'.format(url, title or url)


def generate_dupload_config(repos, user):
    return {
        repo: {
            'fqdn': '{}.dupload.dist.yandex.ru'.format(repo),
            'method': 'scpb',
            'incoming': '/repo/{}/mini-dinstall/incoming/'.format(repo),
            'login': user,
            'options': '-o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null',
            'dinstall_runs': 0,
        }
        for repo in repos
    }
