# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types import search_priemka_releasers


class StokerResource(sdk2.Resource):
    """
    Abstract Stoker resource.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers + ['manoprenko']
    auto_backup = True


class StokerModelBinary(StokerResource):
    """
    Stoker model binary.
    """
    arcadia_build_path = 'search/stoker/bin/stoker'


class StokerUIBundle(StokerResource):
    """
    Transpiled, minimized and archived files for Stoker UI.
    """
