# coding: utf-8
from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask


class AuditBitbucketSec(BaseHectorGitTask):
    class Requirements(BaseHectorGitTask.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 64 << 10, None)

    vcs = 'bitbucket'
    hector_command = 'bb'
    use_ssh = True

    def _hector_env(self):
        env = super(AuditBitbucketSec, self)._hector_env()
        env['BB_LOGIN'] = 'x-oauth-token'
        env['BB_PASSWORD'] = sdk2.Vault.data('STOP_LEAK_BB_TOKEN')
        return env
