# coding: utf-8
import sandbox.common.types.client as ctc

from sandbox.projects.stop_leak.base_hector_task.hector import BaseHectorTask
from sandbox.projects.stop_leak.common.task_helper import normalize_author


class AuditDistSec(BaseHectorTask):
    vcs = 'dist'
    hector_command = 'dist'
    use_ssh = False

    class Requirements(BaseHectorTask.Requirements):
        ram = 6 << 10
        cores = 16
        client_tags = ctc.Tag.Group.LINUX

    def _normalize_author(self, author):
        return normalize_author(author)
