# coding: utf-8
import json
import tempfile

from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask


class AuditExternalGistSec(BaseHectorGitTask):
    vcs = 'gist_external'
    hector_command = 'gist'

    class Requirements(BaseHectorGitTask.Requirements):
        dns = ctm.DnsType.DNS64

    def _hector_env(self):
        env = super(AuditExternalGistSec, self)._hector_env()
        env['GH_TOKEN'] = sdk2.Vault.data('STOP_LEAK_GITHUB_EXERNAL_TOKEN')
        return env

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(AuditExternalGistSec, self)._hector_command()
        hector_cmd.append('--gh-url=https://api.github.com/')
        hector_cmd.append('--config=%s' % self.prepare_config())
        return hector_cmd, ant_secret_cmd

    def _parse_report(self, report, repo):
        report = super(AuditExternalGistSec, self)._parse_report(report, repo)
        # FIXME!
        found = False
        for login, r in self.staff_github_repos:
            url = report.get('url')
            if not url:
                continue
            if url.lower().startswith('https://gist.github.com/%s' % r):
                found = True
                report['user'] = login
                report['holders'] = [login]
                break
        if not found:
            report['user'] = 'unknown'
            report['holders'] = ['unknown']
        return report

    def prepare_config(self):
        config = {
            'Users': [u for _, u in self.staff_github_repos],
        }

        cfg_path = tempfile.NamedTemporaryFile(suffix='.hector.json').name
        with open(cfg_path, 'wt') as f:
            f.write(json.dumps(config))
        return cfg_path
