# coding: utf-8
from sandbox import sdk2
from sandbox.projects.stop_leak.base_hector_task.hector_git import BaseHectorGitTask


class AuditGistSec(BaseHectorGitTask):
    vcs = 'gist'
    hector_command = 'gist'
    use_ssh = True

    def _hector_env(self):
        env = super(AuditGistSec, self)._hector_env()
        env['GH_TOKEN'] = sdk2.Vault.data('STOP_LEAK_GITHUB_TOKEN')
        return env

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(AuditGistSec, self)._hector_command()
        ant_secret_cmd = [x for x in ant_secret_cmd if not x.startswith('--num-threads')]
        ant_secret_cmd.append('--num-threads=1')
        return hector_cmd, ant_secret_cmd
