# coding: utf-8
from sandbox.projects.stop_leak.base_hector_task.hector import BaseHectorTask


class AuditPasteSec(BaseHectorTask):
    vcs = 'paste'
    hector_command = 'paste'
    use_ssh = False

    class Requirements(BaseHectorTask.Requirements):
        ram = 6 << 10
        cores = 8

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(AuditPasteSec, self)._hector_command()
        ant_secret_cmd = [x for x in ant_secret_cmd if not x.startswith('--num-threads')]
        ant_secret_cmd.append('--num-threads=1')
        return hector_cmd, ant_secret_cmd
