# coding: utf-8
from sandbox import sdk2
from sandbox.projects.stop_leak.base_hector_task.hector import BaseHectorTask


class AuditPypiSec(BaseHectorTask):
    vcs = 'pypi'
    hector_command = 'pypi'
    use_ssh = False

    class Parameters(BaseHectorTask.Parameters):
        login = sdk2.parameters.String('PyPi login', required=True)

    def _hector_env(self):
        env = super(AuditPypiSec, self)._hector_env()
        env['PYPI_LOGIN'] = self.Parameters.login
        env['PYPI_PASSWORD'] = sdk2.Vault.data('STOP_LEAK_PYPI_PASSWORD')
        return env
