import os
import logging

from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.stop_leak.common.task_helper import normalize_author
from sandbox.projects.stop_leak.base_hector_task.hector import BaseHectorTask


class BaseHectorGitTask(BaseHectorTask):
    class Requirements(BaseHectorTask.Requirements):
        privileged = True
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, 30 << 10, None)
        ram = 6 << 10
        cores = 16

    class Parameters(BaseHectorTask.Parameters):
        excludes = sdk2.parameters.String('Excludes', default='.git,.hg,.svn,.venv,.venv3,node_modules,local,tmp,fixtures,tests,ut')
        not_ignore = sdk2.parameters.Bool('Ignore ".secretsignore" files', default=False)

    def _hector_command(self):
        hector_cmd, ant_secret_cmd = super(BaseHectorGitTask, self)._hector_command()
        if self.Parameters.excludes:
            ant_secret_cmd.append('--excludes=' + self.Parameters.excludes)
        if self.Parameters.not_ignore:
            ant_secret_cmd.append('--not-ignore')
        return hector_cmd, ant_secret_cmd

    def _prepare_env(self):
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('install_git')) as pl:
            sp.check_call(
                os.path.join(os.path.abspath(os.path.dirname(__file__)), 'install_git.sh'),
                stdout=pl.stdout, stderr=pl.stderr)

    def _normalize_author(self, author):
        return normalize_author(author)
