import os
import tempfile
import requests
import shutil

from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.projects.security.resources import SecurityToolBinary


DOWNLOAD_URI = 'https://tools.sec.yandex-team.ru/api/v1/release/{tool}/linux/{version}/{tool}'


def download_secret_search():
    binary_resource = sdk2.Resource.find(
        resource_type=SecurityToolBinary,
        attrs={
            "target": "security/ant-secret/secret-search/bin",
        },
        arch="linux",
        state=ctr.State.READY,
    ).order(-sdk2.Resource.id).first()

    if not binary_resource:
        raise Exception('Failed to find SecretSearch binary')

    return str(sdk2.ResourceData(binary_resource).path)


def download(tool, version):
    download_uri = DOWNLOAD_URI.format(tool=tool, version=version)
    target = os.path.join(tempfile.mkdtemp(), tool)
    try:
        r = requests.get(download_uri, stream=True)
        r.raise_for_status()
        with open(target, 'wb') as f:
            r.raw.decode_content = True
            shutil.copyfileobj(r.raw, f)
    except Exception as e:
        raise Exception('Failed to download tool from url %s: %s' % (download_uri, e))
    os.chmod(target, 0o755)
    return target
