from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.common.types.resource as ctr
from sandbox.projects.stop_leak.resource_types import HectorState


def find_since(task_type):
    tasks = list(sdk2.Task.find(
        type=task_type,
        status=ctt.Status.SUCCESS,
        input_parameters={'release_audit': True},
    ).order(-sdk2.Task.id).limit(1))

    if not len(tasks):
        return 0

    return tasks[0].Parameters.out_since


def find_state(state_type):
    binary_resource = sdk2.Resource.find(
        resource_type=HectorState,
        state=ctr.State.READY,
        attrs=dict(state_type=state_type)
    ).order(-sdk2.Resource.id).first()

    if not binary_resource:
        return None

    return str(sdk2.ResourceData(binary_resource).path)


def normalize_author(author):
    author = author.strip()
    if author.endswith('@yandex-team.ru'):
        return author[:-15]
    return ''


def email_to_author(author):
    return author.split('@', 2)[0]
