from sandbox.projects.stop_leak.common import http


class HecSender(object):
    def __init__(self, token):
        self.token = token
        self.session = None

    def __enter__(self):
        self.session = http.requests_retry_session()
        self.session.headers.update({'Authorization': 'Splunk %s' % self.token})
        return self

    def __exit__(self, exception_type, exception_value, traceback):
        pass

    def send(self, **kwargs):
        resp = self.session.post(
            'https://hatch.yandex.net/services/collector',
            json={'event': flatten_message(kwargs)},
            verify=False
        )
        resp.raise_for_status()


def flatten_message(message):
    result = {}
    for key, value in message.items():
        if isinstance(value, list):
            result[key] = ','.join(value)
        elif isinstance(value, dict):
            for k, v in flatten_message(value).items():
                result[k] = v
        else:
            result[key] = value
    return result
