# coding: utf-8

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.strmticket.resource_types as resource_types

RESOURCES = {
    'strmticket': resource_types.StrmticketBinary,
}


class BuildStrmticket(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build Strmticket project.
    """
    type = 'BUILD_STRMTICKET'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter
    ]

    def get_resources(self):
        return {
            k: {'description': 'strmticket {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return ['search/mon/strmticket/strmticket']

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
