# coding=utf-8
import logging
import os

from sandbox import sdk2
from sandbox.projects.suggest.dicts.Music import BuildMusicDicts

import sandbox.projects.mediasearch.resource_types as resource_types
import sandbox.projects.common.ya_deploy.release_integration as release_integration


class BuildCustomMusicDicts(release_integration.ReleaseToYaDeployTask2, BuildMusicDicts):
    """ Build custom music dictionaries from yt data """

    class Parameters(BuildMusicDicts.Parameters):
        target_resource_name = sdk2.parameters.String(
            'Value for \'name\' field in target resource with dicts',
            name='target_resource_name',
            default='music_deltas'
        )

        yp_token_yav_secret_id = sdk2.parameters.String('yav YP token secret ID', required=False)

    class Requirements(BuildMusicDicts.Requirements):
        pass

    def on_execute(self):
        proxy = 'hahn.yt.yandex.net'
        token = sdk2.Vault.data(self.Parameters.yt_token_vault_name)
        self.setup_yt_client(proxy=proxy, token=token)

        self.music_yt_folder = self.get_music_yt_folder()
        logging.info('Using folder ' + self.music_yt_folder)

        self.prepare_music_export(self.music_yt_folder)

        self.dicts_path = os.path.join(os.getcwd(), 'dicts')
        os.makedirs(self.dicts_path)

        for dict_name in self.Parameters.suggest_types:
            self.build_dict_with_sub_dicts(dict_name)

        self.write_source_info()
        self.publish_dict(
            self.Parameters.target_resource_name,
            'Suggest dictionaries for Yandex.Music',
            self.dicts_path,
            ttl=4,
            autodeploy=self.Parameters.autodeploy)

    def get_music_yt_folder(self):
        return self.Parameters.music_export_dir

    def publish_dict(self, name, description, path, autodeploy=False, ttl='inf'):
        params = dict()
        params['ttl'] = ttl
        if autodeploy:
            params['autodeploy'] = 'yes'

        dict_resource = resource_types.MusicCustomSuggestDict(self, description, path=path, name=name, **params)
        sdk2.ResourceData(dict_resource).ready()

    def on_release(self, params):
        if self.Parameters.yp_token_yav_secret_id is not None:
            release_integration.ReleaseToYaDeployTask2.on_release(self, params)
        else:
            logging.debug('No YP token provided for this task, skipping release to y.deploy')
        self.mark_released_resources(params["release_status"], ttl=7)
