import os
from sandbox import sdk2
from sandbox.projects.common import file_utils as fu
from sandbox.projects.suggest.dicts import SuggestDictTask


class BuildSampleSuggestDict(sdk2.Task, SuggestDictTask):
    """ Sample task that uses data builder to build a dictionary """

    @staticmethod
    def prepare_dict_files(data_path):
        queries_path = os.path.join(data_path, 'queries')
        fu.write_lines(queries_path, ['something something\t\t10\n'])

        groups_path = os.path.join(data_path, 'groups')
        fu.write_lines(groups_path, ['\n'])

        streams_path = os.path.join(data_path, 'streams')
        fu.write_lines(streams_path, ['ALL\t100\n'])

        return queries_path, groups_path, streams_path

    def on_execute(self):
        cwd = os.getcwd()

        data_path = os.path.join(cwd, 'data')
        os.makedirs(data_path)
        queries_path, groups_path, streams_path = self.prepare_dict_files(data_path)

        dict_path = os.path.join(cwd, 'dict')
        os.makedirs(dict_path)
        dict_prefix = os.path.join(dict_path, 'dict')

        self.run_data_builder(dict_prefix, queries_path, groups_path, streams_path)
        self.publish_dict('sample', 'Sample suggest dictionary created by sandbox task', dict_path)
