import os
import time
from sandbox import sdk2
from sandbox.projects.suggest.dicts import SuggestDictTask


def current_timestamp():
    return int(time.time())


class BuildSimpleSuggestDict(sdk2.Task, SuggestDictTask):
    """ Build easy suggest dictionary """

    class Parameters(sdk2.Task.Parameters):
        dictionary_name = sdk2.parameters.String("Dictionary name", default="dict", required=True)
        sandbox_name = sdk2.parameters.String("Sandbox name", required=True)
        dictionary_description = sdk2.parameters.String('Description', default='Simple dictionary')
        autodeploy = sdk2.parameters.Bool('Autodeploy', default=False)
        source_table_path = sdk2.parameters.String('Source table path', required=True)
        yt_cluster = sdk2.parameters.String('YT cluster', default='hahn')
        yt_token_vault_name = sdk2.parameters.String('YT token vault record', default='SUGGEST_YT_TOKEN')

        store_data = sdk2.parameters.Bool('Store data', default=True)
        word_index = sdk2.parameters.Bool('WordIndex enabled', default=True)
        threads_count = sdk2.parameters.Integer('Threads count', default=1)
        candidates_count = sdk2.parameters.Integer('Candidates count', default=10)
        stop_word_count = sdk2.parameters.Integer('Stop-word-count', default=300000)
        stop_prefix_count = sdk2.parameters.Integer('Stop-prefix-count', default=150000)
        write_aliases = sdk2.parameters.Bool('Write aliases for suggestions', default=False)
        word_index_prefix = sdk2.parameters.Integer('Prefix word index size', default=0)
        enable_regional_frequencies = sdk2.parameters.Bool('Enable regional frequencies', default=False)
        enable_regional_corrected_frequencies = sdk2.parameters.Bool('Enable regional corrected frequencies', default=False)
        min_regional_weight = sdk2.parameters.Integer('Min regional weight', default=0)

        create_dict_info = sdk2.parameters.Bool("Create dict info file", default=False)
        start_ts = sdk2.parameters.Integer("Start timestamp for whole build dict process", default=0)

    def on_execute(self):
        os.environ['YT_TOKEN'] = sdk2.Vault.data(self.Parameters.yt_token_vault_name)

        dict_name = self.Parameters.dictionary_name
        dict_path = os.path.join(os.getcwd(), dict_name)
        dict_prefix = os.path.join(dict_path, dict_name)
        os.makedirs(dict_path)

        self.run_simple_data_builder(
            dict_prefix=dict_prefix,
            source_path=self.Parameters.source_table_path,
            yt_cluster=self.Parameters.yt_cluster,
            store_data=self.Parameters.store_data,
            word_index=self.Parameters.word_index,
            candidates_count=self.Parameters.candidates_count,
            thread_count=self.Parameters.threads_count,
            stop_word_count=self.Parameters.stop_word_count,
            stop_prefix_count=self.Parameters.stop_prefix_count,
            write_aliases=self.Parameters.write_aliases,
            word_index_prefix=self.Parameters.word_index_prefix,
            enable_regional_frequencies=self.Parameters.enable_regional_frequencies,
            enable_regional_corrected_frequencies=self.Parameters.enable_regional_corrected_frequencies,
            min_regional_weight=self.Parameters.min_regional_weight,
            require_geodata=True,
        )

        start_ts = self.Parameters.start_ts if self.Parameters.start_ts else current_timestamp()
        if self.Parameters.create_dict_info:
            self.create_dict_info(dict_name, dict_path, start_ts)

        self.publish_dict(self.Parameters.sandbox_name,
                          self.Parameters.dictionary_description,
                          dict_path,
                          autodeploy=self.Parameters.autodeploy)
