import os
from shutil import copyfile
from sandbox import sdk2
from sandbox.projects.common import utils
from sandbox.projects.suggest.dicts import SuggestDictTask
from sandbox.projects.ydo.suggest.GenSuggestDicts import YdoSuggestDicts


class BuildYdoSuggestDict(sdk2.Task, SuggestDictTask):
    """ Build Ydo dictionary from YdoSuggestDicts resource """

    class Parameters(sdk2.Task.Parameters):
        suggest_handlers = sdk2.parameters.String('Comma separated list with suggest_handler attribute values for YDO_SUGGEST_DICTS resources', default='ydo')

    def on_execute(self):
        suggest_handlers_list = self.Parameters.suggest_handlers.split(',')
        for suggest_handler in suggest_handlers_list:
            suggest_handler = suggest_handler.strip()

            source_path = utils.sandbox_resource(YdoSuggestDicts, 'suggest_handler', suggest_handler)
            os.chmod(source_path, 0777)

            queries_path = os.path.join(source_path, 'queries')
            groups_path = os.path.join(source_path, 'groups')
            streams_path = os.path.join(source_path, 'streams')
            data_path = os.path.join(source_path, 'data')

            cwd = os.getcwd()
            dict_path = os.path.join(cwd, suggest_handler)
            os.makedirs(dict_path)
            dict_prefix = os.path.join(dict_path, 'ydo')

            self.run_data_builder(dict_prefix,
                                  queries_path,
                                  groups_path,
                                  streams_path,
                                  data_path,
                                  word_index=True,
                                  top_size=1000)

            rubric_data_src = os.path.join(source_path, 'rubric_data')
            rubric_data_dst = os.path.join(dict_path, 'rubric_data')
            copyfile(rubric_data_src, rubric_data_dst)

            self.publish_dict(suggest_handler, 'Suggest binary dictionary for Ydo service', dict_path, autodeploy=True)
