import os

from sandbox import sdk2
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class PackArcadiaFiles(sdk2.Task):
    ''' Pack arcadia files into export dir '''

    class Parameters(sdk2.Task.Parameters):
        export_dir = sdk2.parameters.String('Export dir name', default='export_dir', required=True)
        arcadia_paths = sdk2.parameters.String('Semicolon separated paths in Arcadia', required=True)
        resource_type = sdk2.parameters.String('Resource type', default='ARCADIA_PROJECT', required=True)
        resource_description = sdk2.parameters.String('Pack description', default='Arcadia pack')
        attributes = sdk2.parameters.Dict('Attributes for created resource', default={})

    def on_execute(self):
        # Svn export single files and files from dirs to export_dir
        export_dir = self.Parameters.export_dir.strip()
        if '/' in export_dir:
            raise SandboxTaskFailureError('Export dir can not contain symbol "/"')
        os.mkdir(export_dir)
        for arcadia_path in self.Parameters.arcadia_paths.split(';'):
            arcadia_path = arcadia_path.strip()
            if not arcadia_path:
                raise SandboxTaskFailureError('Arcadia path is empty!')
            sdk2.svn.Arcadia.export(sdk2.svn.Arcadia.trunk_url(arcadia_path), export_dir)

        # Publish pack
        resource_type = sdk2.Resource[self.Parameters.resource_type]
        dict_resource = resource_type(self, self.Parameters.resource_description, export_dir, **self.Parameters.attributes)
        sdk2.ResourceData(dict_resource).ready()
