from sandbox import sdk2
from sandbox.projects.resource_types import releasers as resource_releasers


class SuggestExecutable(sdk2.Resource):
    """ Base class for suggest executable resource types """

    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.suggest_releasers
    ttl = 'inf'


class SuggestDataBuilderExecutable(SuggestExecutable):
    """ A tool that builds suggest dictionaries """

    arcadia_build_path = 'quality/trailer/suggest/data_builder/suggest-data-builder'


class SuggestWebDaemonExecutable(SuggestExecutable):
    """ Suggest server """

    arcadia_build_path = 'quality/trailer/suggest/web_fastcgi_daemon/suggest-web-daemon'


class QualityTestExecutable(sdk2.Resource):
    """ quality test for suggest web server """

    arcadia_build_path = 'quality/trailer/suggest/tests/quality_test/quality_test'


class RichStorageBuilderExecutable(SuggestExecutable):
    """ rich_storage_builder to build rich storage dict """

    arcadia_build_path = 'quality/trailer/suggest/rich_storage_builder/rich_storage_builder'


class SuggestRichStorage(sdk2.Resource):
    """ Suggest rich storage dict """

    any_arch = True
    auto_backup = True
    executable = False
    __default_attribute__ = sdk2.parameters.String


class SuggestEcomDicts(sdk2.Resource):
    """ Suggest ecom dictionaries """

    any_arch = True
    auto_backup = True
    executable = False
    __default_attribute__ = sdk2.parameters.String


class SuggestMarketModelRegions(sdk2.Resource):
    """ Suggest market model regions"""

    any_arch = True
    auto_backup = True
    executable = False
    __default_attribute__ = sdk2.parameters.String


class SuggestSamplerExecutable(SuggestExecutable):
    """ sampler on sugget base """

    arcadia_build_path = 'quality/trailer/suggest/base/tools/sampler/sampler'


class TagsBaseExecutable(sdk2.Resource):
    """ build-tags-base for doing tags for images|video """

    arcadia_build_path = 'quality/trailer/suggest/base/build_tags'


class SuggestTestData(sdk2.Resource):
    """ Dictionaries, configs, whatever else necessary to run tests """

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = resource_releasers.suggest_releasers
    hint = sdk2.Attributes.String("Data description", required=False)


class SuggestConfigs(sdk2.Resource):
    """ Suggest configs """

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = resource_releasers.suggest_releasers
    __default_attribute__ = sdk2.parameters.String


class SuggestFilters(sdk2.Resource):
    """Suggest filters"""
    auto_backup = True
    releasers = resource_releasers.suggest_releasers


class SuggestPornoDictFilters(sdk2.Resource):
    """Suggest porno dict filters"""

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = resource_releasers.suggest_releasers
    __default_attribute__ = sdk2.parameters.String


class SuggestPornoTrie(sdk2.Resource):
    """Suggest dict with porno prefixes"""
    auto_backup = True


class SuggestModels(sdk2.Resource):
    """Suggest ML models"""
    auto_backup = True
    __default_attribute__ = sdk2.parameters.String


class SuggestBaseAbacus(SuggestExecutable):
    """ Redir log metrics tool """

    arcadia_build_path = 'quality/trailer/suggest/base/abacus/bin/abacus'


class SuggestBaseBeholder(SuggestExecutable):
    """ Human-readable formatter """

    arcadia_build_path = 'quality/trailer/suggest/base/beholder/beholder'


class SuggestBaseUserSessionsProcessor(SuggestExecutable):
    """ Daily sessions processing tool """

    arcadia_build_path = 'quality/trailer/suggest/base/user_sessions_processor/bin/user_sessions_processor'


class SuggestBaseForge(SuggestExecutable):
    """ Suggest base swiss army knife """

    arcadia_build_path = 'quality/trailer/suggest/base/forge/bin/forge'


class SuggestBaseMrDataBuilder(SuggestExecutable):
    """ Dictionary builder """

    arcadia_build_path = 'quality/trailer/suggest/base/mr_data_builder/bin/mr_data_builder'


class SuggestTolokaLastTable(SuggestExecutable):
    """ Get last common access and response logs table """

    arcadia_build_path = 'quality/trailer/suggest/toloka_processor/get_last_common_table/suggest-toloka-get-last-table'


class SuggestTolokaProcessor(SuggestExecutable):
    """ Get toloka processor """

    arcadia_build_path = 'quality/trailer/suggest/toloka_processor/toloka_processor'


class SuggestTolokaReport(SuggestExecutable):
    """ Get toloka reporeter for yt|solomon """

    arcadia_build_path = 'quality/trailer/suggest/toloka_processor/report_yt/suggest-toloka-report-yt'


class SuggestImagesTagsSerps(sdk2.Resource):
    """suggest serps from selected resource"""
    auto_backup = True
    releasers = resource_releasers.suggest_releasers


class SuggestTailDictBuilder(SuggestExecutable):
    """ Suggest tail dict builder """

    arcadia_build_path = 'quality/trailer/suggest/suggest_tail_builder/suggest_tail_builder'


class SuggestTailFragmentsPreparator(SuggestExecutable):
    """ Suggest word index table preparator """

    arcadia_build_path = 'quality/trailer/suggest/fragments_selector_for_tail/fragments_selector_for_tail'


class SuggestInfixForToloka(SuggestExecutable):
    """
    Tool for processing suggest infix with toloks
    https://wiki.yandex-team.ru/SERP/suggest/infixmarkup/
    """

    arcadia_build_path = 'quality/trailer/suggest/infix_for_toloka/extract-infix'


class SuggestPornoTrieBuilder(SuggestExecutable):
    """ Suggest porno trie builder """

    arcadia_build_path = 'quality/trailer/suggest_dict/tools/porno_trie_builder/porno_trie_builder'


class SuggestCronExecutable(SuggestExecutable):
    """ Suggest cron """

    arcadia_build_path = 'quality/trailer/suggest/cron/bin'


class SuggestEcomBuilderExecutable(SuggestExecutable):
    """ Suggest ecom """

    arcadia_build_path = 'quality/trailer/suggest/turbo_ecom/bin/ecom_builder'


class SuggestMarketBuilderExecutable(SuggestExecutable):
    """ Suggest market builder """

    arcadia_build_path = 'quality/trailer/suggest/market/builder/bin/market_builder'


class SuggestSimpleDataBuilderExecutable(SuggestExecutable):
    """ Suggest simple data builder """

    arcadia_build_path = 'quality/trailer/suggest/base/simple_data_builder/bin/simple_data_builder'
