import os
from os import listdir
from os.path import isfile, join
import logging
import time
import json
import httplib

from sandbox import sdk2


# ------------------------------------------------------------------------------------------------------------------
def checkout_from_svn(desc, path):
    logging.info('checkout: %s', desc)
    full_path = 'arcadia:/arc/trunk/' + path
    res = sdk2.svn.Arcadia.get_arcadia_src_dir(full_path)
    cwd_files = ' '.join(os.listdir(res))
    logging.info('svn checkout info')
    logging.info('name: %s', desc)
    logging.info('localpath: %s', res)
    logging.info('arcadia path: %s', full_path)
    logging.info('files: %s', cwd_files)
    return res
# end checkout_from_svn
# ------------------------------------------------------------------------------------------------------------------


class SuggestBashBurn(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("properties") as props:
            directory = sdk2.parameters.String(
                "directory for check",
                name="directory",
                default='arcadia/quality/trailer/suggest_dict/suggest_framework',
                required=False
            )

        with sdk2.parameters.Group("solomon") as solomon:
            host = sdk2.parameters.String(
                "solomon host",
                name="host",
                default='solomon.yandex-team.net',
                required=True
            )
            project = sdk2.parameters.String(
                "solomon project",
                name="project",
                default='suggest',
                required=True
            )
            cluster = sdk2.parameters.String(
                "solomon cluster",
                name="cluster",
                default='main',
                required=True
            )
            service = sdk2.parameters.String(
                "solomon service",
                name="service",
                default='bash_scripts',
                required=True
            )
            token = sdk2.parameters.String(
                "solomon token",
                name="token",
                default='SUGGEST_YT_TOKEN',
                required=True
            )

    def calc(self, directory):

        def file_len(fname):
            with open(fname) as f:
                for i, _ in enumerate(f):
                    pass
            return i + 1

        bash_scripts = [f for f in listdir(directory) if isfile(join(directory, f)) and f.endswith('.sh')]
        count = len(bash_scripts)
        lines = 0
        for script in bash_scripts:
            lines += file_len(directory + '/' + script)
        return count, lines

    def push_into_solomon(self, count, lines):
        ts = time.time()
        data = {
            'sensors': [
                {
                    'labels': {
                        'sensor': 'files'
                    },
                    'kind': 'IGAUGE',
                    'ts': ts,
                    'value': count
                },
                {
                    'labels': {
                        'sensor': 'lines'
                    },
                    'kind': 'IGAUGE',
                    'ts': ts,
                    'value': lines
                }
            ]
        }
        data = json.dumps(data, ensure_ascii=False, sort_keys=True).encode('utf-8')
        headers = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth {0}'.format(sdk2.Vault.data(self.Parameters.token))
        }
        push_str_url = '/api/v2/push?project=' + self.Parameters.project + '&cluster=' + \
                       self.Parameters.cluster + '&service=' + self.Parameters.service
        for attempt in range(0, 60):
            try:
                logging.info('host: {0}'.format(self.Parameters.host))
                logging.info('url: {0}'.format(push_str_url))
                logging.info('data: {0}'.format(data))

                conn = httplib.HTTPConnection(self.Parameters.host)
                conn.request('POST', push_str_url, data, headers)
                response = conn.getresponse()
                print 'response ' + str(response.status) + ' ' + str(response.reason)
                if response.status != 200:
                    raise Exception('error while push into solomon {0} with status {1} desc {2}'.format(
                        push_str_url, response.status, response.reason))
                break
            except httplib.HTTPException:
                time.sleep(10)
    # push_into_solomon

    def on_execute(self):

        logging.info('checkout')
        logging.info('checkout suggest_dict from svn')
        path_suggest_dict = checkout_from_svn('suggest_framework', self.Parameters.directory)

        logging.info('calculate')
        count, lines = self.calc(path_suggest_dict)

        logging.info('push')
        self.push_into_solomon(count, lines)

        logging.info('done')

# end
