# coding: utf-8
import logging
import httplib
import time

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.suggest import resource_types
from sandbox.projects.geobase.Geodata5BinStable import resource as gbr
from sandbox.projects.resource_types import SUGGEST_DICT as SUGGEST_DICT
import sandbox.sandboxsdk.environments as sdk_environments
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class CheckSuggestDictQuality(sdk2.Task):
    """ run and public qulity test result on dict """

    class Requirements(sdk2.Requirements):
        environments = [sdk_environments.PipEnvironment('yandex-yt'), ]

    class Parameters(sdk2.Task.Parameters):

        class Parameters(sdk2.Task.Parameters):
            with sdk2.parameters.Group("Properties") as properties:
                dict_type = sdk2.parameters.String(
                    "base|tail",
                    name='suggest dict type',
                    default='base',
                    required=False
                )
                dict_name = sdk2.parameters.String(
                    "dict name for test(for example: touch_base|desktop_base)",
                    name="dict_name",
                    required=True
                )
                samples_table = sdk2.parameters.String(
                    "table with sample",
                    name="samples_table",
                    required=False
                )
                samples_table_mask = sdk2.parameters.String(
                    "mask for samples with macros $ts",
                    name="samples_table_mask",
                    required=False
                )
                ts = sdk2.parameters.String(
                    "timestamp of nano session",
                    name="ts",
                    required=True
                )
                dict_name_for_report = sdk2.parameters.String(
                    "dict name for report in graph",
                    name="dict_name_for_report",
                    required=False
                )
            with sdk2.parameters.Group("Solomon") as solomon:
                solomon_host = sdk2.parameters.String(
                    "solomon host(solomon-prestable.yandex.net|...)",
                    name="solomon_host",
                    required=True
                )
                solomon_project = sdk2.parameters.String(
                    "solomon project for push",
                    name="solomon_project",
                    default="suggest",
                    required=True
                )
                solomon_cluster = sdk2.parameters.String(
                    "solomon cluster",
                    name="solomon_cluster",
                    default="main",
                    required=True
                )
                solomon_service = sdk2.parameters.String(
                    "solomon service",
                    name="solomon_service",
                    default="dicts",
                    required=True
                )
                solomon_token = sdk2.parameters.String(
                    "solomon token",
                    name="token",
                    default='SUGGEST_SOLOMON_TOKEN',
                    required=True
                )
            with sdk2.parameters.Group("YT setting") as yt_settings_block:
                yt_cluster = sdk2.parameters.String(
                    "YT cluster (i.e. hahn)",
                    name="yt_cluster",
                    default="hahn",
                    required=False,
                )
                yt_token = sdk2.parameters.String(
                    "YT token vault name",
                    name="yt_token",
                    default="YT_TOKEN_SUGGEST",
                    required=True,
                )

    def on_execute(self):
        # reading sample
        import yt.wrapper as yt
        yt.config["proxy"]["url"] = self.Parameters.yt_cluster
        yt.config["token"] = sdk2.Vault.data(self.Parameters.yt_token)
        with open('sample.txt', 'w') as f:
            samples = self.Parameters.samples_table
            if self.Parameters.samples_table_mask:
                samples = self.Parameters.samples_table_mask.replace(
                    '$ts', self.Parameters.ts)
            for row in yt.read_table(yt.TablePath(samples),
                                     format='<has_subkey=false>yamr'):
                print >> f, '\t'.join([row.key, row.value])

        # take geobase
        logging.info('GET GEOBASE')
        resources = sdk2.Resource.find(
            resource_type=gbr.GEODATA5BIN_STABLE,
            state='READY',
        ).limit(3)
        last = sorted(list(resources), key=lambda x: x.created)[-1]
        resource_path_geobase = str(sdk2.ResourceData(last).path)
        logging.info('geobase path: ' + str(resource_path_geobase))
        self.set_info('get geobase done')

        # take dict
        logging.info('GET DICT')
        resources = sdk2.Resource.find(
            resource_type=SUGGEST_DICT,
            state='READY',
            attrs={'name': self.Parameters.dict_name}
        ).limit(3)
        last = sorted(list(resources), key=lambda x: x.created)[-1]
        resource_path_dict = str(sdk2.ResourceData(last).path)
        logging.info('reousrce path: ' + str(resource_path_dict))
        self.set_info('get dict done')

        # take quality test
        logging.info('GET QUALITY_TEST')
        resources = sdk2.Resource.find(
            resource_type=resource_types.QualityTestExecutable,
            state='READY'
        ).limit(3)
        last = sorted(list(resources), key=lambda x: x.created)[-1]
        resource_path_quality_test = str(sdk2.ResourceData(last).path)
        logging.info('reousrce path: ' + str(resource_path_quality_test))
        self.set_info('get quality_test done')

        # creating config
        config = None
        if self.Parameters.dict_type == 'base':
            config = '''<?xml version="1.0" ?>
                        <fastcgi>
                            <components>
                                <component name="suggest-fcgi-daemon">
                                    <dictionary>
                                        <path>{0}/dict</path>
                                    </dictionary>
                                    <enable-fast-suggest>0</enable-fast-suggest>
                                    <request-nahodki-for-suggests>0</request-nahodki-for-suggests>
                                    <geo-base-path>{1}</geo-base-path>
                                </component>
                            </components>
                        </fastcgi>'''.format(resource_path_dict, resource_path_geobase)
        else:
            config = '''<?xml version="1.0" ?>
                        <fastcgi>
                            <components>
                                <component name="suggest-fcgi-daemon">
                                    <tail-dictionary-compressed>
                                        <path>{0}</path>
                                    </tail-dictionary-compressed>
                                    <enable-fast-suggest>0</enable-fast-suggest>
                                    <request-nahodki-for-suggests>0</request-nahodki-for-suggests>
                                    <geo-base-path>{1}</geo-base-path>
                                </component>
                            </components>
                        </fastcgi>'''.format(resource_path_dict, resource_path_geobase)
        assert config is not None
        with open('daemon.conf', 'w') as f:
            print >> f, config

        # check quality
        with sdk2.helpers.ProcessLog(self, logger="check") as pl:
            dict_name = self.Parameters.dict_name_for_report if self.Parameters.dict_name_for_report else self.Parameters.dict_name
            cmd = resource_path_quality_test + ' daemon.conf sample.txt --json_out 1' + \
                ' --ts ' + self.Parameters.ts + \
                ' --dict_name ' + dict_name + \
                ' --out solomon.export'

            logging.info('call: %s', cmd)
            command = sp.Popen(
                cmd, shell=True, stdout=pl.stdout, stderr=pl.stderr)
            out, err = command.communicate()
        self.set_info('run quality_test done')

        with open('solomon.export') as f:
            data = f.read()
            self.set_info('data:{0}'.format(data))
            headers = {
                'Content-Type': 'application/json',
                'Authorization': 'OAuth {0}'.format(sdk2.Vault.data(self.Parameters.solomon_token))
            }
            push_str_url = '/api/v2/push?project=' + self.Parameters.solomon_project + '&cluster=' + \
                self.Parameters.solomon_cluster + '&service=' + self.Parameters.solomon_service

            logging.info('host: {0}'.format(self.Parameters.solomon_host))
            logging.info('url: {0}'.format(push_str_url))
            logging.info('data: {0}'.format(data))

            for c in range(0, 60):
                try:
                    conn = httplib.HTTPConnection(self.Parameters.solomon_host)
                    conn.request('POST', push_str_url, data, headers)
                    response = conn.getresponse()
                    logging.info('response ' + str(response.status) +
                                 ' ' + str(response.reason))
                    if response.status != 200:
                        raise SandboxTaskFailureError('error while push into solomon {0} with status {1} desc {2}'.format(
                            push_str_url, response.status, response.reason))
                    return
                except httplib.HTTPException:
                    time.sleep(10)

            raise SandboxTaskFailureError(
                'reached maximum count tries for push into solomon {0}'.format(self.Parameters.solomon_host))
# CheckSuggestDictQuality
