import logging
import os

import sandbox.sdk2 as sdk2
from sandbox.projects.suggest.resource_types import SuggestMarketModelRegions, SuggestMarketBuilderExecutable
from sandbox.sandboxsdk.process import run_process


class BuildSuggestMarketModelRegions(sdk2.Task):
    ''' Build multi ecom dict '''

    class Parameters(sdk2.Task.Parameters):
        market_base_folder = sdk2.parameters.String('Market base yt folder', required=True)
        folder_name = sdk2.parameters.String('Output folder name', required=True)
        max_age = sdk2.parameters.Integer('Max regions age', default=14)
        date = sdk2.parameters.String("Date for base build in YYYY-MM-DD format", default="")

        builder_owner = sdk2.parameters.String('SUGGEST_MARKET_BUILDER_EXECUTABLE owner', default='SUGGEST-TEST', required=True)
        vault_user = sdk2.parameters.String('Sandbox vault user with YT token', default='SUGGEST', required=True)
        vault_yt_token_name = sdk2.parameters.String('YT token name from Sandbox vault', default='SUGGEST_YT_TOKEN', required=True)
        yt_cluster = sdk2.parameters.String('YT cluster', default='hahn', required=True)
        resource_description = sdk2.parameters.String('Resource description', default='Market model regions', required=True)
        attributes = sdk2.parameters.Dict('Resource attributes', default={})

    def on_execute(self):
        # Write YT token from Vault to file
        token_value = sdk2.Vault.data(self.Parameters.vault_user, self.Parameters.vault_yt_token_name)
        with open('yt_token.txt', 'w') as t:
            t.write(token_value)

        export_dir = self.Parameters.folder_name
        os.mkdir(export_dir)

        # Get ecom builder executable
        market_builder = sdk2.Resource.find(resource_type=SuggestMarketBuilderExecutable, state='READY', owner=self.Parameters.builder_owner).first()
        market_builder_path = str(sdk2.ResourceData(market_builder).path)
        logging.info('market_builder_path: ' + market_builder_path)

        # Form builder command
        cmd = [market_builder_path, 'model-regions',
               '--market-base-folder', self.Parameters.market_base_folder,
               '--output-folder', export_dir,
               '--cluster', self.Parameters.yt_cluster,
               '--yt-token-path', 'yt_token.txt',
               '--max-age', str(self.Parameters.max_age)]
        if self.Parameters.date != "":
            cmd += ['--date', self.Parameters.date]
        logging.info('Run command: ' + ' '.join(cmd))

        # Run builder command
        run_process(cmd, log_prefix="market_builder", wait=True, shell=True)
        logging.info('market regions have been built')

        # Publish rich storage dict
        resource_type = SuggestMarketModelRegions
        dict_resource = resource_type(self, self.Parameters.resource_description, export_dir, **self.Parameters.attributes)
        sdk2.ResourceData(dict_resource).ready()
