from sandbox import sdk2
from sandbox.sandboxsdk import environments

import os
import logging


class PackYtDir(sdk2.Task):
    """ Pack YT directory or file as Sandbox resource """

    class Parameters(sdk2.Task.Parameters):
        yt_token_vault_name = sdk2.parameters.String('Name of the vault record with YT token', default='SUGGEST_YT_TOKEN', required=True)
        yt_proxy = sdk2.parameters.String('YT proxy', default="hahn.yt.yandex.net", required=True)
        yt_path = sdk2.parameters.String('YT path to pack', required=True)
        resource_type = sdk2.parameters.String('Resource type', default='OTHER_RESOURCE', required=True)
        resource_description = sdk2.parameters.String('Pack description', default='Yt dir pack')
        attributes = sdk2.parameters.Dict('Attributes for created resource', default={})

    class Requirements(sdk2.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
        )

    def on_execute(self):
        import yt.wrapper as yt

        token = sdk2.Vault.data(self.owner, self.Parameters.yt_token_vault_name)
        yt_client = yt.YtClient(proxy=self.Parameters.yt_proxy, token=token)

        def yt_recurse_download(yt_path, local_path):
            node_type = yt_client.get(os.path.join(yt_path, "@type"))
            basename = os.path.basename(yt_path)
            local_node_path = os.path.join(local_path, basename)

            if node_type == "file":
                logging.info("file: " + yt_path)
                stream = yt_client.read_file(yt_path)
                with open(local_node_path, 'wb') as f:
                    f.write(stream.read())

            elif node_type == "map_node":
                logging.info("dir: " + yt_path)
                os.mkdir(local_node_path)

                for node in yt_client.list(yt_path):
                    yt_recurse_download(os.path.join(yt_path, node), local_node_path)

            return local_node_path

        download_dir = "pack"
        os.mkdir(download_dir)
        local_target_path = yt_recurse_download(self.Parameters.yt_path, download_dir)
        logging.info("local_target_path: " + local_target_path)

        # Publish pack
        resource_type = sdk2.Resource[self.Parameters.resource_type]
        dict_resource = resource_type(self, self.Parameters.resource_description, local_target_path, **self.Parameters.attributes)
        sdk2.ResourceData(dict_resource).ready()
