import os

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as ya_make_parameters


class SuggestBuildTask(YaMakeTask):
    """ Base task that builds suggest tools """

    input_parameters = [
        ya_make_parameters.ArcadiaUrl,
        ya_make_parameters.BuildType,
        ya_make_parameters.StripBinaries,
        ya_make_parameters.Sanitize,
    ] + ya_make_parameters.get_aapi_parameters_as_default()

    client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX
    cores = 24

    target_resource_types = []

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx[ya_make_parameters.StripBinaries.name] = True
        self.ctx['result_single_file'] = True

    def get_resources(self):
        resources = {}
        for resource_type in self.target_resource_types:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_targets(self):
        return [
            resource_type.arcadia_build_path for resource_type in self.target_resource_types
        ]

    def get_arts(self):
        return [
            {'path': resource_type.arcadia_build_path} for resource_type in self.target_resource_types
        ]

    def on_execute(self):
        YaMakeTask.on_execute(self)
