from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.common.nanny import nanny
import requests
import json
import logging
import six


class SupTankerMessages(sdk2.Resource):
    """
    Contains single file - JSON array of tanker messages
    """

    releasable = True
    releasers = ['SUP']
    any_arch = True


class FetchSupMessages(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        projects = sdk2.parameters.List("Tanker projects to fetch", default=["sup"])
        tanker = sdk2.parameters.String("Tanker endpoint", default="https://tanker-api.yandex-team.ru")
        language = sdk2.parameters.String("Language to fetch from tanker", default="ru")

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    def _fetch_project(self, project):
        fetched = []
        params = {
            'project-id': project
        }

        url = self.Parameters.tanker + "/projects/export/json"
        resp = requests.get(url, params=params)
        resp.raise_for_status()
        data = resp.json()[self.Parameters.language]
        for keyset_name, keyset_data in data.items():
            for k, v in keyset_data.items():
                logging.info("importing %s/%s/%s", project, keyset_name, k)
                assert isinstance(v, six.string_types)
                fetched.append({'project': project, 'language': self.Parameters.language, 'keyset': keyset_name, 'key': k, 'text': v})
        return fetched

    def _fetch_all(self):
        fetched = []
        for project in self.Parameters.projects:
            fetched += self._fetch_project(project)
        return fetched

    def on_execute(self):
        messages = self._fetch_all()
        messages = json.dumps(messages)
        resource = SupTankerMessages(self, "Tanker messages", "messages.json")
        resource.path.write_bytes(messages)
