import logging
from sandbox import sdk2

from sandbox.projects.sup.PushBuild import PushBuild

from sandbox.sandboxsdk.process import run_process
import sandbox.common.types.task as ctt

SVN_URL = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sup/push'


class PushBuildCi(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 2048
        ram = 2048
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    class Parameters(sdk2.Task.Parameters):
        mvn_cmd = sdk2.parameters.String("Addditional Maven command line parameters", required=False)
        pass

    class Context(sdk2.Context):
        # zero value means no subtask was created yet
        subtask_id = 0

    def on_execute(self):
        if self.Context.subtask_id > 0:
            if self.Context.subtask_id > self.id:
                self.server.release(task_id=self.Context.subtask_id, type=ctt.ReleaseStatus.UNSTABLE, subject='SUP CI/CD')
            else:
                logging.info("skipping release because PUSH_BUILD task is cached")
        else:
            rev = run_process(
                ['svn', 'info', SVN_URL, '|', 'awk', "'/^Last Changed Rev:/ {print $4}'"],
                'svn',
                outs_to_pipe=True,
                shell=True
            ).stdout.read().strip().decode()

            child_context = {
                'svn': SVN_URL,
                'mvn_cmd': self.Parameters.mvn_cmd,
                'env_type': 'testing'
            }
            child_context = [{'name': k, 'value': v} for k, v in child_context.items()]
            subtask_id = self.server.task(
                type=PushBuild.type,
                owner=self.owner,
                chidldren=True,
                uniqueness=dict(key=rev, excluded_statuses=["EXCEPTION", "FAILURE"]),
                description='CI',
                custom_fields=child_context,
                push_tasks_resource=True
            )['id']
            subtask = sdk2.Task[subtask_id]
            subtask.enqueue()
            self.Context.subtask_id = subtask_id
            logging.info("Created PUSH_BUILD child %d", subtask_id)
            raise sdk2.WaitTask([subtask.id], list(ctt.Status.Group.BREAK + ctt.Status.Group.FINISH))

    def on_release(self, additional_parameters):
        pass
