# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import os
import sys
import logging

from yql.api.v1.client import YqlClient

from yql_query import query as _yql_query


def main():
    yql_token = os.environ['YQL_TOKEN']
    client = YqlClient(token=yql_token)
    request = client.query(_yql_query)
    request.run()
    request.get_results()

    if not request.get_results().is_success:
        error_description = '\n'.join([str(err) for err in request.get_results().errors])
        logging.error(error_description)
        sys.exit(1)
    else:
        sys.exit(0)


if __name__ == '__main__':
    logging.basicConfig(stream=sys.stderr, level=logging.INFO)
    main()
