# -*- coding: utf-8 -*-
from __future__ import unicode_literals

query = \
"""
use hahn;

PRAGMA yt.InferSchema;
PRAGMA yt.Owners = 'antonka,zador,dpolukhin,robot-sup';
PRAGMA yt.Pool = 'sup';
PRAGMA yt.DefaultCluster = 'hahn';

$check_known_errors_script = @@
def check_known_errors(value):
    known_errors_starts = {
        'zoneId is null': 'NullZoneId',
        'ttl exceeded': 'TTLExceeded',
        'window already closed': 'WindowClosed',
        'window not opened yet': 'WindowNotOpened',
        'http': 'HTTP',
        'no transport': 'NoTransport',
        'disabled by its': 'DisabledByIts',
        'rate limiter not available': 'RateLimiterNotAvailable',
        'serialization': 'Serialization',
        'rle by': 'RateLimiter',
        'revoke': 'Revoke',
        'retry': 'Retry',
    }
    known_errors_contains = {
        'Connection timed out': 'ConnectionTimedOut',
        'Network is unreachable': 'NetworkUnreachable',
        'InvalidRegistration': 'InvalidRegistration',
        'MismatchSenderId': 'MismatchSenderId',
        'timeout': 'Timeout',
        'NotRegistered': 'NotRegistered',
        'Unregistered': 'Unregistered',
        'BadDeviceToken': 'BadDeviceToken',
        'expired': 'Expired',
    }
    for _ in known_errors_starts:
        if value.startswith(_):
            return known_errors_starts[_]
    for _ in known_errors_contains:
        if _ in value:
            return known_errors_contains[_]
    return 'Other'
@@;
$check_known_errors = Python::check_known_errors("(String?)->String", $check_known_errors_script);

$push_chunks_path = '//statbox/push-chunks-log';
$push_stats_path = '//home/search-functionality/sup/push_stats';
$day = DateTime::ToDate(DateTime::TimestampFromDays(DateTime::ToDays(YQL::Now()) - 1));

$input = String::JoinFromList(
    ListExtend(
        AsList($push_chunks_path),
        AsList($day ?? "")
    ), "/"
);

$output = String::JoinFromList(
    ListExtend(
        AsList($push_stats_path),
        AsList($day ?? ""),
        AsList("push_failed_to_send"),
    ), "/"
);

$intermediate_stats = (
    select reason, count(*) as num, '1' as merge
    from
        (
            select $check_known_errors(reason) as reason
            from $input
            where
                reason is not null
                and state == 'fail'
        )
    group by reason
);

$total_fail_num = (
    select sum(num) as total_fail_num, merge
    from $intermediate_stats
    group by merge
);

$total_sent_num = (
    select count(*) as total_sent_num, '1' as merge
    from $input
    where state == 'sent'
    group by state
);

INSERT INTO $output with truncate
SELECT
    SOME(IF(reason=="Unregistered", num)) as unregistered,
    SOME(IF(reason=="RateLimiter", num)) as ratelimiter,
    SOME(IF(reason=="NotRegistered", num)) as notregistered,
    SOME(IF(reason=="Timeout", num)) as timeout,
    SOME(IF(reason=="MismatchSenderId", num)) as mismatchsenderid,
    SOME(IF(reason=="InvalidRegistration", num)) as invalidregistration,
    SOME(IF(reason=="Revoke", num)) as revoke,
    SOME(IF(reason=="NullZoneId", num)) as nullzoneid,
    SOME(IF(reason=="TTLExceeded", num)) as ttlexceeded,
    SOME(IF(reason=="NetworkUnreachable", num)) as networkunreachable,
    SOME(IF(reason=="ConnectionTimedOut", num)) as connectiontimedout,
    SOME(IF(reason=="BadDeviceToken", num)) as baddevicetoken,
    SOME(IF(reason=="Expired", num)) as expired,
    SOME(IF(reason=="WindowClosed", num)) as windowclosed,
    SOME(IF(reason=="WindowNotOpened", num)) as windownotopened,
    SOME(IF(reason=="HTTP", num)) as http,
    SOME(IF(reason=="NoTransport", num)) as notransport,
    SOME(IF(reason=="DisabledByIts", num)) as disabledbyits,
    SOME(IF(reason=="RateLimiterNotAvailable", num)) as ratelimiternotavailable,
    SOME(IF(reason=="Serialization", num)) as serialization,
    SOME(IF(reason=="Retry", num)) as retry,
    SOME(IF(reason=="Other", num)) as other,
    SOME(total_fail_num) as total_fail,
    SOME(total_sent_num) as total_sent,
    $day as fielddate
FROM
    (
        SELECT
            a.reason as reason,
            a.num as num,
            b.total_fail_num as total_fail_num,
            c.total_sent_num as total_sent_num
        FROM $intermediate_stats as a
        INNER JOIN $total_fail_num as b
        ON a.merge == b.merge
        INNER JOIN $total_sent_num as c
        ON b.merge == c.merge
    )
"""
