import os
import logging
import sandbox.common.types.task as ctt

from sandbox import common
from sandbox.projects.common.nanny import nanny
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.sup import SUP_STAFF_UIDS_CONFIG

class SUP_STAFF_GRABBER(sdk2.Resource):
    """
        StaffGrabber binary to get uids list from staff
    """
    any_arch = True
    executable = True

class StaffUidsGrabTask(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Update staff-uids.config"""

    def on_execute(self):
        os.environ['STAFF_TOKEN'] = sdk2.Vault.data('robot_sup_staff_token')

        bin_resource = self._find_bin_resource()
        if not bin_resource:
            raise common.errors.TaskFailure("No binaries found!")

        last_binary_path = str(sdk2.ResourceData(bin_resource).path)

        with sdk2.helpers.ProcessLog(self, logger="staff_uids_grab_task") as pl:
            sp.check_call([last_binary_path], stdout=pl.stdout, stderr=sp.STDOUT)

        resource = SUP_STAFF_UIDS_CONFIG(
            self,
            'uids.config',
            unicode(self.path('uids.config'))
        )
        sdk2.ResourceData(resource).ready()


    def _find_bin_resource(self):
        binary_resources = list(
            sdk2.Resource.find(
                resource_type=SUP_STAFF_GRABBER,
                state='READY'
            ).limit(3)
        )

        if len(binary_resources) > 0:
            return max(binary_resources, key=lambda x: x.created)


    def on_release(self, additional_parameters):
        super(StaffUidsGrabTask, self).on_release(additional_parameters)

    def on_success(self, prev_status):
        logging.info("task succeed")
        sdk2.Task.on_success(self, prev_status)
        for status in [ctt.ReleaseStatus.UNSTABLE, ctt.ReleaseStatus.PRESTABLE, ctt.ReleaseStatus.STABLE]:
            nanny.ReleaseToNannyTask2.on_release(self, dict(
                releaser=self.author,
                release_status=status,
                release_subject="StaffUidsGrabTask",
                email_notifications=dict(to=[], cc=[]),
                release_comments="StaffUidsGrabTask",
            ))
        logging.info("task release complete")
