# -*- coding: utf-8 -*-

import logging

import sandbox.common.types.client as ctc

from sandbox.projects.common import constants as consts
from sandbox.projects.common.build import parameters as ya_make_parameters
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.sup import BASS_YASTROKA_FIXLIST_TOOL

logger = logging.getLogger(__name__)


class BassYaStrokaFixListTool(YaMakeTask):
    type = 'BUILD_BASS_YASTROKA_FIXLIST_TOOL'

    input_parameters = [
        ya_make_parameters.ArcadiaUrl,
        ya_make_parameters.ClearBuild,
        ya_make_parameters.StripBinaries,
        ya_make_parameters.CheckReturnCode,
        ya_make_parameters.YaTimeout
    ]

    execution_space = 40 * 1024
    required_ram = 4 * 1024
    cores = 24
    client_tags = ctc.Tag.Group.LINUX

    target_path = 'alice/bass/tools/yastroka_fixlist'
    rev_attr = 'rev'

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx['result_single_file'] = True
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx['targets'] = self.target_path
        self.ctx['arts'] = '{}/mktrie'.format(self.target_path)
        self.ctx['result_rt'] = BASS_YASTROKA_FIXLIST_TOOL.name

    def get_build_type(self):
        return consts.RELEASE_BUILD_TYPE

    def get_resources_attrs(self):
        return {'project': {'ttl': 'inf'}}
